/*******************************************************************************
MODULE    : types.h

20101007 AB     Initial
20171223 AB     Added MPARAMs for PCM
*******************************************************************************/

// --- Includes ---------------------------------------------------------------

// --- Pin Definitions --------------------------------------------------------

// --- Defines ----------------------------------------------------------------
#define TRUE  1
#define FALSE 0

#define ON    1
#define OFF   0

#define BOOL  BYTE

/*** Macros to make an MPARAM from standard types. *************************/

#define MPVOID                     ((MPARAM)0L)
#define MPFROMP(p)                 ((MPARAM)((ULONG)(p)))
#define MPFROMHWND(hwnd)           ((MPARAM)(HWND)(hwnd))
#define MPFROMCHAR(ch)             ((MPARAM)(USHORT)(ch))
#define MPFROMSHORT(s)             ((MPARAM)(USHORT)(s))
#define MPFROM2SHORT(s1, s2)       ((MPARAM)MAKELONG(s1, s2))
#define MPFROMSH2CH(s, uch1, uch2) ((MPARAM)MAKELONG(s, MAKESHORT(uch1, uch2)))
#define MPFROMLONG(l)              ((MPARAM)(ULONG)(l))

/*** Macros to extract standard types from an MPARAM ***********************/

#define PVOIDFROMMP(mp)            ((void *)(mp))
#define HWNDFROMMP(mp)             ((HWND)(mp))
#define CHAR1FROMMP(mp)            ((UCHAR)((ULONG)mp))
#define CHAR2FROMMP(mp)            ((UCHAR)((ULONG)mp >> 8))
#define CHAR3FROMMP(mp)            ((UCHAR)((ULONG)mp >> 16))
#define CHAR4FROMMP(mp)            ((UCHAR)((ULONG)mp >> 24))
#define SHORT1FROMMP(mp)           ((USHORT)(ULONG)(mp))
#define SHORT2FROMMP(mp)           ((USHORT)((ULONG)mp >> 16))
#define LONGFROMMP(mp)             ((ULONG)(mp))

// --- Typedefs ---------------------------------------------------------------

#ifndef _INTEGER
  #define _INTEGER

  #ifdef _WIN32
    #include <windows.h>
    #include <tchar.h>

  #else     /* Embedded platform */
    #include "stdint.h"

    /* These types must be 16-bit, 32-bit or larger integer */
    typedef int16_t   INT;
    typedef uint16_t  UINT;

    /* These types must be 8-bit integer */
    typedef int8_t    CHAR;
    typedef uint8_t   UCHAR;
    typedef uint8_t   BYTE;

    /* These types must be 16-bit integer */
    typedef int16_t   SHORT;
    typedef uint16_t  USHORT;
    typedef uint16_t  WORD;
    typedef uint16_t  WCHAR;

    /* These types must be 32-bit integer */
    typedef int32_t   LONG;
    typedef uint32_t  ULONG;
    typedef uint32_t  DWORD;
  #endif

#endif


typedef void *MPARAM;

// --- PUBLIC Variables -------------------------------------------------------

// --- Macros -----------------------------------------------------------------

// --- Functionprototypes -----------------------------------------------------


