/******************************************************************************
MODULE    : TraceLeUart.c
  Traceing facility via LEUART
  Enabled via trace.h globally and/or module based
  TRACE messages are written out via LEUART

20101005 AB initial
******************************************************************************/

// --- Includes ---------------------------------------------------------------
#include <stdio.h>
#include "trace.h"

// --- Pin Definitions --------------------------------------------------------

// --- Defines ----------------------------------------------------------------

// --- Typedefs ---------------------------------------------------------------

// --- PUBLIC Variables -------------------------------------------------------

// --- Variables --------------------------------------------------------------
#ifndef NO_TRACE
  extern int iTraceBufLen;
  extern char szTraceBuf[];
#else
#endif  // NO_TRACE


// --- Macros -----------------------------------------------------------------

// --- Functionprototypes -----------------------------------------------------
  char * TraceGetBuildTime(void);
  char * TraceGetBuildDate(void);

//#ifndef NO_TRACE
  void trace (int);
  void trace_NoLF (int iLen);
  void TraceInit (void);
  void TraceInit2(void);
  void TraceTicker1s(void);
  void TracePrintUptime(void);
  void TracePrintStartTime(void);
  void TracePrintIRQs(void);
  char TraceGetKey(void);
  void TraceWriteUptimeToNvm(void);
  void TraceWriteStartupTimeToNvm (void);
  void TraceReadUptimeFromNvm(void);
  void TracePrintHwInfo(void);
  void TracePrintKeypadInfo(void);
  void TracePrintFirmwareVersion(void);
  int  TraceCommandAvail(void);
  void TraceCommandAvailDec(void);
  int TraceIsRunning(void);
//else
//endif // NO_TRACE


