/*******************************************************************************
MODULE      :   Hardware.c
  Hardware related functions, detecting hardware type (physical  board layout)
  and revision, manage MAC address, validate application software (as soon as in
  application flashing is implemented)

20101117 AB     Initial
20180808 AB     Adapted to CAN-Tester
20191219 AB     Adapted for JADE EFM32JG1B test
*******************************************************************************/

// --- Includes ---------------------------------------------------------------
#define LOGGING_TOKEN    HW_LOGGING
#include "TraceLeUart.h"

#include <efm32.h>
#include <em_cmu.h>
#include <em_gpio.h>
#include <em_usart.h>
#include <em_timer.h>

#include "types.h"
#include "Hardware.h"

// --- Pin Definitions --------------------------------------------------------
/*#define PORT      gpioPortB
#define PORT_BIT  6
#define TESTPIN_INIT();       { GPIO_PinModeSet(PORT, PORT_BIT, gpioModePushPull, 0);}
#define TESTPIN( x );         { if ( x ) GPIO->P[PORT].DOUT |=  ( 1 << PORT_BIT ); \
                                else     GPIO->P[PORT].DOUT &= ~( 1 << PORT_BIT ); }
*/
// --- Defines ----------------------------------------------------------------

// --- Typedefs ---------------------------------------------------------------

// --- PUBLIC Variables -------------------------------------------------------

// --- Variables --------------------------------------------------------------
static BYTE bHwType = 0;
static BYTE bHwVersion = 0;
static BYTE bHwRevision = 0;

// --- Macros -----------------------------------------------------------------

// --- Functionprototypes -----------------------------------------------------

;
// --- Code -------------------------------------------------------------------
/******************************************************************************
void HwInit (void)
  Initialize module Hardware part 1
******************************************************************************/
void HwInit (void)
  {
  TRACE("HW:  init");

  }

/******************************************************************************
int HwGetType(void);
  Returns hardware type previously read from config pins
******************************************************************************/
int HwGetType(void)
  {
  return bHwType;
  }


/******************************************************************************
int HwGetVersion(void);
  Returns hardware version previously read from config pins
******************************************************************************/
int HwGetVersion(void)
  {
  return bHwVersion;
  }

/******************************************************************************
int HwGetRevision(void);
  Returns hardware revision
  Currently not defined so 0 is returned
******************************************************************************/
int HwGetRevision(void)
  {
  return bHwRevision;
  }

/******************************************************************************
void HwTraceHwInfo(void)
******************************************************************************/
void HwTraceInfo(void)
  {
  TRACE ("HW:  switch 0x%02X", HwGetType() );
  }

/******************************************************************************
void _delay_us (int us)
  Delays specified number of micro seconds. Valid for EFM32G880 & EFM32GG380
  running at standard HFRCO frequency (6.6MHz)
******************************************************************************/

// have to be at the end of source file cause overrides optimization level

// min. is about 4us (including pin H/L before/after)
// 10   --> 12us
// 6000 --> 5ms

#pragma GCC optimize ("-O0")

void _delay_us( int us )
  {

//  TESTPIN(1);
#ifdef HW_MASTER
  // master runs with 28MHz
  us <<= 1;
#endif
  while (us--);
//  TESTPIN(0);
  }



