/*******************************************************************************
MODULE    : trace.h

19xxxxxx AB     Initial
*******************************************************************************/

// --- Includes ---------------------------------------------------------------

// --- Pin Definitions --------------------------------------------------------

// --- Defines ----------------------------------------------------------------
//#define NO_TRACE      // uncomment this line to disable ALL tracing and save ROM space
#ifndef NO_TRACE
  // module specific logging level (0...3)
  #define MAI_LOGGING         2
  #define TRA_LOGGING         1
  #define COMMAND_LOGGING     1
  #define NVM_LOGGING         1
  #define COM_LOGGING         1   // 3 to much delay to proper decode telegram
  #define CRC_LOGGING         2
  #define MAS_LOGGING         1
  #define SLV_LOGGING         2
  #define IIC_LOGGING         1
  #define HW_LOGGING          2
  #define ADC_LOGGING         1
  #define REL_LOGGING         1
  #define TIM_LOGGING         1
  #define INP_LOGGING         3
  #define LED_LOGGING         3
  #define EVE_LOGGING         1
#else
  // all values should be 0 here (global disable)
  #define MAI_LOGGING         1
  #define TRA_LOGGING         0
  #define COMMAND_LOGGING     0
  #define NVM_LOGGING         0
  #define COM_LOGGING         0
  #define IIC_LOGGING         0
  #define CRC_LOGGING         0
  #define MAS_LOGGING         0
  #define SLV_LOGGING         0
  #define HW_LOGGING          0
  #define ADC_LOGGING         0
  #define REL_LOGGING         0
  #define TIM_LOGGING         0
  #define INP_LOGGING         0
  #define LED_LOGGING         0
  #define EVE_LOGGING         0
#endif  // NO_TRACE

#ifndef LOGGING_TOKEN
  // for using TRACE macros in modules define LOGGING_TOKEN
  // this are the tokens used in the defines above which select logging intensity
  // f.i. #define LOGGING_TOKEN   MAI_LOGGING
  //      #include "trace.h"
  #error "LOGGING_TOKEN must be defined before including trace.h"
#endif

#ifdef LOGGING_TOKEN
  #define TRACE( ... )                            trace(sprintf(szTraceBuf, __VA_ARGS__ ))
  #define TRACE_L2( ... )   if(LOGGING_TOKEN>1)   trace(sprintf(szTraceBuf, __VA_ARGS__ ))
  #define TRACE_L3( ... )   if(LOGGING_TOKEN>2)   trace(sprintf(szTraceBuf, __VA_ARGS__ ))
  #define TRACE_NOLF( ... )                       trace_NoLF(sprintf(szTraceBuf, __VA_ARGS__ ))
#else
  #define TRACE( ... )
  #define TRACE_L2( ... )
  #define TRACE_L3( ... )
  #define TRACE_NOLF( ... )
#endif

//#undef  LOGGING_TOKEN
//#define LOGGING_TOKEN   3   // in case it was forgotten in table above set to max

// --- Typedefs ---------------------------------------------------------------

// --- PUBLIC Variables -------------------------------------------------------

// --- Variables --------------------------------------------------------------

// --- Macros -----------------------------------------------------------------

//Dummy_for_() { int WARNING;       /* to generate compiler warning */ return 1; }
