/*******************************************************************************
MODULE      :   leds.c
  Driver for LEDs. Derived from EM sample code/library.

20101007 AB     Initial G880 Olimex
20150323 AB     Changed to BS-OI3 Port PF3..5
20170826 AB     Added BS-OI3 Port PE13..15 for LED10, 11, 12 (red, green, blue)
20191213 AB     Adapted for JADE STK3401A
*******************************************************************************/

// --- Includes ---------------------------------------------------------------
#define LOGGING_TOKEN LED_LOGGING
#include "TraceLeUart.h"

#include <efm32.h>
#include <em_cmu.h>
#include "em_gpio.h"

#include "leds.h"

// --- Pin Definitions --------------------------------------------------------
//  PF4 is used for TRACE_LEUART_RX
// #define LED0_INIT()        { GPIO_PinModeSet(gpioPortF, 4, gpioModePushPull, 0);}
//#define LED0_OUT( x )       { if ( x ) GPIO_PinOutSet(gpioPortF, 4); else GPIO_PinOutClear(gpioPortF, 4); }
//#define LED0_GET()            GPIO_PinOutGet(gpioPortF, 4)

//  PF5 pinX  (for search in project - Testpin_on)
#define LED2_INIT()         { GPIO_PinModeSet(gpioPortF, 5, gpioModePushPull, 0);}
#define LED2_OUT( x )       { if ( x ) GPIO->P[gpioPortF].DOUT |= 1 << 5; else GPIO->P[gpioPortF].DOUT &= ~(1 << 5); }
#define LED2_GET            GPIO_PinOutGet(gpioPortF, 5)

// --- Defines ----------------------------------------------------------------

// --- Typedefs ---------------------------------------------------------------

// --- PUBLIC Variables -------------------------------------------------------

// --- Variables --------------------------------------------------------------

// --- Macros -----------------------------------------------------------------

// --- Functionprototypes -----------------------------------------------------

// --- Code -------------------------------------------------------------------
/**************************************************************************//**
 * @brief Light up LED
 * @param led LED number (0-2), 1 not used as not populated on STK
 *****************************************************************************/
void LED_Set(int led)
  {
  if (led < 3)
    {
    switch (led)
      {
      case 0:
//        LED0_OUT(1);
        break;

      case 2:
        LED2_OUT(1);
        break;

      default:
        TRACE_L2("LED: wrong number %d", led);
        break;
      }
    }
  }

/**************************************************************************//**
 * @brief Turn off LED
 * @param led LED number (0-2), 1 not used as not populated on STK
 *****************************************************************************/
void LED_Clear(int led)
  {
  if (led < 3)
    {
    switch (led)
      {
      case 0:
//        LED0_OUT(0);
        break;

      case 2:
        LED2_OUT(0);
        break;

      default:
        TRACE_L2("LED: wrong number %d", led);
        break;
      }
    }
  }

/**************************************************************************//**
 * @brief Toggle LED, switch from on to off or vice versa
 * @param led LED number (0-2), 1 not used as not populated on STK
 *****************************************************************************/
void LED_Toggle(int led)
  {
  if (led < 3)
    {
    switch (led)
      {
      case 0:
//        if ( LED0_GET() ) LED_Clear(0);
//          else LED_Set(0);
        break;

      case 2:
        if ( LED2_GET ) LED_Clear(2);
          else LED_Set(2);
        break;

      default:
        TRACE_L2("LED: wrong number %d", led);
        break;
      }
    }
  }

/**************************************************************************//**
 * @brief Initialize LED interface
 *****************************************************************************/
void LedInit(void)
  {

  TRACE_L2("LED: init");    // usually no output as TRACE is not initialized when called
  /* Enable GPIO */
  CMU_ClockEnable(cmuClock_GPIO, true);

  /* Configure GPIO port PF4 and PF5 as LED control outputs */
//  LED0_INIT();
  LED2_INIT();

  /* Light them all */
  LedOn(0);
  LedOn(2);
  }
