/*******************************************************************************
MODULE    : Hardware.h
DESCRIPTION :

20101117 AB     Initial
20180808 AB     Adapted to CAN-Tester
*******************************************************************************/

// --- Includes ---------------------------------------------------------------

// --- Pin Definitions --------------------------------------------------------

// --- Defines ----------------------------------------------------------------
//#define HW_MASTER           1           // set only for Master
#undef  HW_MASTER                       // without defined code works for master and slave
                                        // on-the-fly switching by DIP-switches (CAN-Tester)

#ifdef HW_MASTER
  #define HW_DESCRIPTION    "CAN-Mas"   // description text, usually no more than 8 chars
  #define HW_MAC_ADDRESS    0x50A0      // default hardware MAC address if not defined in NVM
  #define HW_PRIORITY_CLASS 1           // prefered priority class
#else
  #define HW_SLAVE          1           // set only for Slaves

  #define HW_DESCRIPTION    "CAN-Slv"   // description text, usually no more than 8 chars
  #define HW_MAC_ADDRESS    0xA0A0      // default hardware MAC address if not defined in NVM
  #define HW_PRIORITY_CLASS 16          // prefered priority class
#endif //HW_MASTER

#define HW_NUM_PRIORITY_GROUPS     32    // number of priority groups
#define HW_NUM_SLAVES_PER_GROUP    16

#define HW_LEN_DESC         0 //8
#define HW_LEN_DESC_SHORT   0 //4
#define HW_LEN_DESC_LONG    0 //64        // lengt of description strings without trailing '/0'

#define HW_ADDR_NOT_DEFINED         0x200 // beyond top most address
#define HW_FIRST_SLAVE_ADDR         0x10  // first valid slave address for USV_BatteryMonitor & CAN-Tester

#define HW_EEPROM_24AA08                  // type of EEPROM
//#define HW_EEPROM_24LC256

// --- Typedefs ---------------------------------------------------------------

// --- PUBLIC Variables -------------------------------------------------------

// --- Variables --------------------------------------------------------------

// --- Macros -----------------------------------------------------------------

// --- Functionprototypes -----------------------------------------------------
void HwPreInit(void);
void HwInit(void);
void HwInit1(void);
int  HwGetMacAddr(void);
void HwSetMacAddr(int);
char *HwGetDescriptionShort(void);
char *HwGetDescription(void);
char *HwGetDescriptionLong(void);
void HwSetDescriptionShort(char *);
void HwSetDescription(char *);
void HwSetDescriptionLong(char *);

int HwGetIsAB(void);
int HwGetType(void);
int HwGetVersion(void);
int HwGetRevision(void);
int HwGetIssue(void);
int HwGetBooterType(void);
int HwGetBooterVersion(void);
int HwGetBooterRevision(void);
int HwGetBooterIssue(void);
int HwGetAppType(void);
int HwGetAppVersion(void);
int HwGetAppRevision(void);
int HwGetAppIssue(void);

int  HwGetPriorityClass (void);
void HwSetPriorityClass (int);
void HwTraceInfo(void);
void HwTraceVoltages(void);
void HwTicker500ms(void);
void HwLoggingToggle(void);
void HwLogging(BOOL flag);
void HwSetCorrectionVolt(int);
void HwSetCorrectionCurrentGain(int);
void HwSetCorrectionCurrentZero(void);
int  HwGetLineVoltage(void);
int  HwGetVcap(void);
int  HwGetEnergy(void);
int  HwGetCurrent(void);
void HwTraceCorrection(void);
void HwPcmPower(BOOL bState);
int HwGetPcmCurrent(void);
void HwStartFastStart(BOOL bState);
void HwSyncAddrToDIP(void);

;
void _delay_us( int us );


